<?php

namespace App\Http\Requests\Validations;

use App\Http\Requests\Request;

class CreateCategoryRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'category_sub_group_id' => 'required',
            'name' => 'required',
            'slug' => 'required|alpha_dash|unique:categories',
            'image' => 'mimes:jpg,jpeg,png,svg',
            'active' => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            // 'address_type.composite_unique' => trans('validation.composite_unique'),
        ];
    }
}
